#include <stdio.h>
#include <string.h>

struct Student
{
    int id;
    char name[50];
    int age;
    char address[100];
};

void addStudent(struct Student *students, int *numOfStudents)
{
    printf("Enter student ID: ");
    scanf("%d", &students[*numOfStudents].id);
    getchar();

    printf("Enter student name: ");
    fgets(students[*numOfStudents].name, sizeof(students[*numOfStudents].name), stdin);

    printf("Enter student age (between 18 to 24): ");
    scanf("%d", &students[*numOfStudents].age);
    getchar();

    if (students[*numOfStudents].age < 18 || students[*numOfStudents].age > 24)
    {
        printf("Invalid age. Age must be between 18 to 24.\n");
        return;
    }

    printf("Enter student address: ");
    fgets(students[*numOfStudents].address, sizeof(students[*numOfStudents].address), stdin);

    (*numOfStudents)++;

    printf("Student added successfully.\n");
}

void searchStudent(struct Student *students, int numOfStudents)
{
    int searchId;
    printf("Enter student ID to search: ");
    scanf("%d", &searchId);
    getchar();

    for (int i = 0; i < numOfStudents; i++)
    {
        if (students[i].id == searchId)
        {
            printf("Student details:\n");
            printf("ID: %d\n", students[i].id);
            printf("Name: %s", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s", students[i].address);
            return;
        }
    }

    printf("Student with ID %d not found.\n", searchId);
}

int main()
{
    struct Student students[100];
    int numOfStudents = 0;
    int choice;
    do
    {
        printf("\n1. Add a student\n");
        printf("2. Search student by ID\n");
        printf("3. Exit\n");
        printf("Enter your choice: ");
        scanf("%d", &choice);
        getchar();

        switch (choice)
        {
        case 1:
            addStudent(students, &numOfStudents);
            break;
        case 2:
            searchStudent(students, numOfStudents);
            break;
        case 3:
            break;
        default:
            printf("Invalid choice\n");
        }
    } while (choice != 3);

    printf("Exited Sucessfully\n");
    return 0;
}
